FreeRADIUS 3.0.x configuration template for eduroam in South Africa
===================================================================

This is a bare bones template for deploying eduroam using FreeRADIUS 3.x
in South Africa. It is designed to be unpacked into your raddb directory,
and it will change/replace files that are needed to make eduroam work.

**Note** this is not a complete configuration. You will need to make some
changes to match your local site. In particular, you will need to supply
your realm(s) in appropriate places and you will need to configure an
authentication backend (see below).

The configuration used in this template is strongly aligned with the
documentation on GÉANT's wiki, and uses similar stanzas and block
names. You can find the GÉANT documentation that informed the template at:

 * <https://wiki.geant.org/display/H2eduroam/freeradius-sp>
 * <https://wiki.geant.org/display/H2eduroam/freeradius-idp>

This template was last updated 2025-01-20. An up-to-date copy can be
obtained from <https://eduroam.ac.za/static/FreeRADIUS-eduroam-Template-ZA.tar.gz>

Configuration
-------------

### RADIUS secrets

You will need to update the RADIUS shared secret for the two South African
FLR servers (_flr-cpt_ & _flr-jnb_) to match those you've negotiated
with the South African NRO (TENET). The secret exists in:

 * <clients.conf> (2 client blocks)
 * <proxy.conf> (2 home_server blocks)

The security of the RADIUS protocol depends COMPLETELY on this secret! We
recommend using a shared secret that at LEAST 20 characters long.
It should  preferably be 32 characters in length.  The secret MUST
be random, and should not be words, phrase, or anything else that is
recognisable.

### Realm

The template configures eduroam for the _example.ac.za_ realm. You will
need to supply your correct, valid realm(s) in the appropriate places
in the following files:

 * <proxy.conf> (realm blocks)
 * <sites-enabled/eduroam> (Operator-Name)
 * <mods-enabled/eap> (EAP-PWD)

### Authentication

The template configures the FreeRADIUS
[rlm_files](https://freeradius.org/radiusd/man/rlm_files.html)
module for authentication. This uses a static "users" file in
<mods-config/files/authorize> for user credentials.

Whilst this may be useful for small sites, it is generally
more practical to use one of the other modules such as
[rlm_ldap](https://wiki.freeradius.org/modules/Rlm_ldap) or
[rlm_sql](https://wiki.freeradius.org/modules/Rlm_sql) to connect to an
existing directory service or person registry. Configuration of these
backends will depend on the specifics of your own site, and is beyond the
scope of this template. However, since it is a common use-case, there
are some commented out entries in <sites-enabled/eduroam-inner-tunnel>
showing how you might do this for LDAP.

One use of the rlm_files module, even on large sites, is to configure the
_nren_radius_test_ user that is required by national policy. The template
creates such a user, but you will need to set a good random password
for it in [mods-config/files/authorize](mods-config/files/authorize)
and then update the monitoring configuration in the [eduroam management
portal](https://eduroam.ac.za/manage/instrealmsmon).

### Chargeable-User-Identity

Support for Chargeable-User-Identity is enabled by default in the
template, but you need to set a good `cui_hash_key` in <policy.d/cui>
so your users' privacy is preserved.  A possible way to generate a good
`cui_hash_key` is by running the following command from a unix shell:

```
  tr -c -d '0123456789abcdefghijklmnopqrstuvwxyz' </dev/urandom | dd bs=32 count=1 2>/dev/null;echo
```

### EAP

The only change that's needed to in EAP configuration (<mods-enabled/eap>)
is to set an explict realm for the PWD EAP type (replacing example.ac.za).

If you're using a limited backend (such as rlm_ldap), you may also want
to disable those EAP methods you cannot support (i.e. MSCHAPv2).

### Logging

Logging is configured to use the custom format described by
<mods-enabled/linelog_eduroam>. This is more detailed than the auth
logging in the log section of <radius.conf>, but less detailed than the
logs generated by [detail.log](https://networkradius.com/doc/current/raddb/mods-available/detail.html)
(`auth_log`, `reply_log`) stanzas. It represents a good compromise between
retaining adequate logs and the size.

By default these logs are written directly to disk in `${logdir}`. You
can change this to use syslog by editing the two `filename` entries in
the <mods-enabled/linelog_eduroam> file.

Remember that policy requires you retain the eduroam-*.log log files
for 184 days. Make sure you set up your log rotation accordingly!

#### Statistics

There is also an <mods-enabled/f_ticks> module that generates some
anonymised statistical information and sends it to syslog. 
[F-Ticks](https://monitor.eduroam.org/08_GN3-10-304v1-DJ3.1.2-1_Roaming_Developments.pdf)
is a widely used and standardised format for eduroam statistical information.

You can retain F-Ticks data indefinately if you want statistical
information about the use of eduroam at your institution.

#### Detail logging

You can also create detailed log of every request and reply
by uncommenting the `auth_log`, `reply_log`, `pre_proxy_log`,
and `post_proxy_log` entries in <sites-enabled/eduroam> and
<sites-enabled/eduroam-inner-tunnel>. This is useful for debugging or
tracing abuse, but can grow very large at busy sites.

Make sure you rotate the contents of `${radacctdir}` if you enable 
detail logging. FreeRADIUS provides a 
[sample logrotate file](https://github.com/FreeRADIUS/freeradius-server/blob/v3.0.x/scripts/logrotate/freeradius).

### Wireless infrastructure (SP only)

The configuration of your wireless infrastructure to support
eduroam is beyond the scope of this template. However, the
_antarctica-access-point-1_ block in <clients.conf> gives you the
configuration required to connect your wireless access point(s) or
wireless controller with this RADIUS server.

You will need to uncomment and edit this block to suit your
requirements. If you have multiple access points or controllers, you
can duplicate the block.

#### Dynamic VLAN assignment

Using dynamic VLAN assignment to put eduroam visitors onto a different
VLAN from your local users is STRONGLY recommended. There are many ways
to achieve this, but an example based on realm matching is shown in
the `post-auth` section of <sites-enabled/eduroam>. If you uncomment
this section you will need to ensure you set the `Tunnel-Private-Group-Id`
attribute values to the correct VLAN ids for your network.

### Message Authenticators

In light of the [Blast!RADIUS vulnerability](https://blastradius.fail),
please ensure you require message authenticators wherever possible.

In <radius.conf>, check `require_message_authenticator` and
`limit_proxy_state` are both set to `auto` (or more preferably,
`yes`).  If these options are not in your <radius.conf>, you
may need to [update your FreeRADIUS to a version >= 3.0.27 or >=
3.2.5](https://www.freeradius.org/security/#2024).

If you set the global settings above to either `no` or `auto`, then
additionally:

 * In <clients.conf>, make sure all clients that support it have
   `require_message_authenticator` set to `yes`.

 * In <proxy.conf>, make sure all home servers that support it have
   `require_message_authenticator` set to `yes`.

The eduroam FLR servers support (and require) message authenticators.

TLS-PSK
-------

Experimental support for RADIUS over TLS with a pre-shared key (TLS-PSK)
is available. This requires FreeRADIUS 3.2.x (not 3.0.x). If you're
interested in configuring this, there are hints on how to go about it
in <sites-available/eduroam-tlspsk>.

Note that as of 3.2.6, using TLS-PSK requires some
form of database lookup, with SQLite used in the
examples. However, FreeRADIUS is still evolving its TLS-PSK
support, and it may be possible to [configure this in the clients
block](https://github.com/FreeRADIUS/freeradius-server/commit/fbc5429a684489aeff499d18163cb5dc54b1230f)
in future.
